<?php
/**
 * Information Two Widget
 */

namespace Elementor;
class Falar_Information_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Information_Two';
    }

	public function get_title() {
        return __( 'Information Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Information_Two_Area',
			[
				'label' => __( 'Information Two Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('International students', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The mission of Luva is to serve as a digital gateway and information hub for all members of the university community.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Additionally, a university website seeks to foster a sense of community and collaboration by facilitating communication and engagement among students, faculty, alumni, and prospective students.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'card_feature_content',
				[
					'label'       => __( 'Feature Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Full time programs for the International students.', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'information_item',
                [
                    'label' => esc_html__('Add Information Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text1',
                [
                    'label'       => __( 'Button Text One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Contact Form', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_link1',
                [
                    'label'       => __( 'Button Link One', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_text2',
                [
                    'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __(' Program Availability', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_link2',
                [
                    'label'       => __( 'Button Link Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
				'user_img1',
				[
					'label'       => __( 'User Image One', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
				'user_img2',
				[
					'label'       => __( 'User Image Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
				'user_img3',
				[
					'label'       => __( 'User Image Three', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'information_content',
                [
                    'label'       => __( 'Information Content', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Connect with a Falar International student via chat.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'chat_btn_text',
                [
                    'label'       => __( 'Chat Button Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Chat Now', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'chat_btn_link',
                [
                    'label'       => __( 'Chat Button Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
				'info_img1',
				[
					'label'       => __( 'Info Image One', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
				'main_logo',
				[
					'label'       => __( 'Main Logo', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
				'text_shape',
				[
					'label'       => __( 'Text Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'information_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content p',
                ]
            );
            $this->add_control(
				'feature_title_color',
				[
					'label'     => __( 'Feature Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content .information-list li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_title_typography',
                    'label'    => __( 'Feature Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content .information-list li',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content .info-button .style2' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content .info-button .style2' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content .info-button .style2',
                ]
            );
            $this->add_control(
				'btn_color2',
				[
					'label'     => __( 'Button Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color2',
				[
					'label'     => __( 'Button Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography2',
                    'label'    => __( 'Button Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            $this->add_control(
				'information_content_color',
				[
					'label'     => __( 'Information Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content .info-link-chat .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'information_content_typography',
                    'label'    => __( 'Information Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content .info-link-chat .content p',
                ]
            );

            $this->add_control(
				'view_btn_color',
				[
					'label'     => __( 'View Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-content .info-link-chat .content .chat-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'view_btn_typography',
                    'label'    => __( 'View Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-content .info-link-chat .content .chat-link',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $information_item = $settings['information_item'];
        ?>

        <!-- Information Warp Start -->
        <div class="information-warp get-way-info-area">
            <div class="container">
                <div class="row align-items-center g-4">
                    <div class="col-lg-6">
                        <div class="information-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?> 
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?> 
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?> 
                            <ul class="information-list">
                                <?php foreach($information_item as $item_information): ?>
                                    <li>
                                        <i class="ti ti-check"></i>
                                        <?php echo wp_kses_post( $item_information['card_feature_content'] ); ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="info-button">
                                <?php if( $settings['btn_link1']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['btn_link1'] ); ?>" class="default-btn style2">
                                        <?php echo wp_kses_post( $settings['btn_text1'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if( $settings['btn_link2']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['btn_link2'] ); ?>" class="default-btn">
                                        <?php echo wp_kses_post( $settings['btn_text2'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="info-link-chat">
                                <ul class="chat-list">
                                    <?php if( $settings['user_img1']['url'] != '' ): ?>
                                        <li>
                                            <div class="image">
                                                <img src="<?php echo esc_url($settings['user_img1']['url'] ) ?>" alt="image">
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                    <?php if( $settings['user_img2']['url'] != '' ): ?>
                                        <li>
                                            <div class="image">
                                                <img src="<?php echo esc_url($settings['user_img2']['url'] ) ?>" alt="image">
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                    <?php if( $settings['user_img3']['url'] != '' ): ?>
                                        <li>
                                            <div class="image">
                                                <img src="<?php echo esc_url($settings['user_img3']['url'] ) ?>" alt="image">
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <div class="content">
                                    <?php if( $settings['information_content']): ?>
                                        <p><?php echo wp_kses_post( $settings['information_content'] ); ?></p>
                                    <?php endif; ?>
                                    <?php if( $settings['chat_btn_link']): ?>
                                        <a href="<?php echo wp_kses_post( $settings['chat_btn_link'] ); ?>" class="chat-link">
                                            <span><?php echo wp_kses_post( $settings['chat_btn_text'] ); ?></span>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6" data-cue="slideInUp">
                        <div class="information-image get-way-info">
                            <?php if( $settings['info_img1']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($settings['info_img1']['url'] ) ?>" class="get-way-ingo-image" alt="image">
                            <?php endif; ?>
                            <div class="round-shape">
                                <?php if( $settings['main_logo']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['main_logo']['url'] ) ?>" class="main-logo" alt="image">
                                <?php endif; ?>
                                <?php if( $settings['text_shape']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['text_shape']['url'] ) ?>" class="text-shape" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Information Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Information_Two );