<?php
/**
 * Jobs Widget
 */

namespace Elementor;
class Falar_Jobs extends Widget_Base {

	public function get_name() {
        return 'Falar_Jobs';
    }

	public function get_title() {
        return __( 'Jobs', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Jobs_Area',
			[
				'label' => __( 'Jobs Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Make a positive jobs move with Luva administration', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('In every field of study, you know that a practical education is what will set you apart, giving you the skills you need to get into the work you want, achieve your jobs goals and reach your full potential.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'jobs_image1',
            [
                'label'       => __( 'Jobs Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'jobs_image2',
            [
                'label'       => __( 'Jobs Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'jobs_image3',
            [
                'label'       => __( 'Jobs Image Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'jobs_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Positive Job Warp Start -->
        <div class="positive-job-warp ptb-100">
            <div class="container">
                <div class="section-warp positive-section">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <?php if( $settings['content']): ?>
                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        <div class="positive-image">
                            <?php if( $settings['jobs_image1']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($settings['jobs_image1']['url'] ) ?>" alt="image">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="positive-image-style2">
                            <div class="jobs-logo">
                                <?php if( $settings['jobs_image2']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['jobs_image2']['url'] ) ?>" class="job-logo" alt="image">
                                <?php endif; ?>
                            </div>
                            <?php if( $settings['jobs_image3']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($settings['jobs_image3']['url'] ) ?>" alt="image">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Positive Job Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Jobs );