<?php
/**
 * Message Widget
 */

namespace Elementor;
class Falar_Message extends Widget_Base {

	public function get_name() {
        return 'Falar_Message';
    }

	public function get_title() {
        return __( 'Message', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Message_Area',
			[
				'label' => __( 'Message Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Send us message in the department to get all sorts of information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The mission of Falar is to serve as a digital gateway and information hub for all members of the university community.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shortcode',
            [
                'label'   => __( 'Contact Form Shortcode', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'message_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .massage-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .massage-content p',
                ]
            );
			$this->add_control(
				'label_color',
				[
					'label'     => __( 'Label Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-form-widget .form-label' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'label_typography',
                    'label'    => __( 'Label Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .massage-form-widget .form-label',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-form-widget .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-form-widget .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .massage-form-widget .default-btn',
                ]
            );
            $this->add_control(
				'form_bg_color',
				[
					'label'     => __( 'Form Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .massage-form-widget' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .changing-wave-area' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

            <!-- Five Massage Area Start -->
            <div class="five-massage-area pt-100">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="massage-content">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['shape']['url'] != '' ): ?>
                                    <div class="logo">
                                        <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="massage-shape" alt="image">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="massage-form-widget">
                                <?php echo do_shortcode( $settings['shortcode'] ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Five Massage Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Message );