<?php
/**
 * Mission Widget
 */

namespace Elementor;
class Falar_Mission extends Widget_Base {

	public function get_name() {
        return 'Falar_Mission';
    }

	public function get_title() {
        return __( 'Mission', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Mission_Area',
			[
				'label' => __( 'Mission Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_item = new Repeater();

            $list_item->add_control(
                'question_title',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_item->add_control(
                'question_content',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item1',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'mission_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-title h2' => 'color: {{MISSION}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .mission-content .mission-list li' => 'color: {{MISSION}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .mission-content .mission-list li',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $question_item1 = $settings['question_item1'];
        ?>

        <!-- Duties Of University Warp Start -->
        <div class="duties-of-university-warp">
            <div class="container">
                <div class="accordion duties-accordion" id="accordionExample">
                    <?php $i = 1;  foreach( $question_item1 as $item_question1 ): 
                        $cl='';
                        if ($i == 1) {
                            $cl='';
                        }else {
                            $cl='collapsed';
                        }

                        if($i <= 10):
                    ?>
                    <?php if( $item_question1['question_title']): ?>
                        <div class="accordion-item">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse1<?php echo $i; ?>">
                                <h2><?php echo esc_attr( $item_question1['question_title']) ?></h2>
                            </button>
                            <div id="collapse1<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="value-content">
                                                <ul class="value-list">
                                                    <?php echo wp_kses_post( $item_question1['question_content']) ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php endif; $i++; endforeach; ?>
                </div>
            </div>
        </div>
        <!-- Duties Of University Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Mission );