<?php
/**
 * Partner Widget
 */

namespace Elementor;
class Falar_Partner extends Widget_Base {

	public function get_name() {
        return 'Falar_Partner';
    }

	public function get_title() {
        return __( 'Partner', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Partner_Area',
			[
				'label' => __( 'Partner Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'partner_image',
				[
					'label'       => __( 'Partner Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'partner_item',
                [
                    'label' => esc_html__('Add Partner Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $partner_item = $settings['partner_item'];
        ?>

        <!-- Partner Area Start -->
        <div class="partner-area ptb-100">
            <div class="container">
                <div class="partner-slider-widget">
                    <div class="swiper partner-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($partner_item as $item_partner): ?>
                                <div class="swiper-slide">
                                    <?php if( $item_partner['partner_image']['url'] != '' ): ?>
                                        <div class="partner-logo">
                                            <img src="<?php echo esc_url($item_partner['partner_image']['url'] ) ?>" class="partner-logo" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Partner Area End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Partner );