<?php
/**
 * Places One Widget
 */

namespace Elementor;
class Falar_Places extends Widget_Base {

	public function get_name() {
        return 'Falar_Places';
    }

	public function get_title() {
        return __( 'Places', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Places_Area',
			[
				'label' => __( 'Places Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'places_image',
				[
					'label'       => __( 'Places Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_icon',
				[
					'label'       => __( 'Link Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('ti ti-arrow-narrow-right', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'places_item',
                [
                    'label' => esc_html__('Add Places Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'places_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .places-widget .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .places-widget .content h3',
                ]
            );
			$this->add_control(
				'a_title_color',
				[
					'label'     => __( 'Active Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .places-warp .swiper-slide-active .places-widget .content h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'a_title_typography',
                    'label'    => __( 'Active Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .places-warp .swiper-slide-active .places-widget .content h3',
                ]
            );
            $this->add_control(
				'card_bg_content_color',
				[
					'label'     => __( 'Card Content Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fun-fact-card p' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $places_item = $settings['places_item'];
        ?>

        <!-- Places Warp Start -->
        <div class="places-warp">
            <div class="container-fluid">
                <div class="places-slider-warp">
                    <div class="swiper places-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($places_item as $item_places): ?>
                                <div class="swiper-slide">
                                    <div class="places-widget">
                                        <?php if( $item_places['places_image']['url'] != '' ): ?>
                                            <img src="<?php echo esc_url($item_places['places_image']['url'] ) ?>" class="mission-shape" alt="image">
                                        <?php endif; ?>
                                        <div class="content">
                                            <h3>
                                                <a href="<?php echo wp_kses_post( $item_places['card_link'] ); ?>"><?php echo wp_kses_post( $item_places['card_title'] ); ?></a>
                                            </h3>
                                            <?php if( $item_places['link_icon']): ?>
                                                <a href="<?php echo wp_kses_post( $item_places['card_link'] ); ?>" class="icon">
                                                    <i class="<?php echo wp_kses_post( $item_places['link_icon'] ); ?>"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Places Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Places );