<?php
/**
 * Program Popular Widget
*/

namespace Elementor;
class Falar_Popular_Program extends Widget_Base {

	public function get_name() {
        return 'Popular_Program';
    }

	public function get_title() {
        return __( 'Popular Program', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'program_section',
			[
				'label' => __( 'Program', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('3. POPULAR PROGRAMS', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Most Popular Tech Programs In The Era Of AI', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'view_btn',
            [
                'label'       => __( 'Card View Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View Program', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'view_btn_icon',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'View Button Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View all Program', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Button Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_program_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Program Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 6,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popular-heading .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .popular-heading .title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .popular-heading h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .popular-heading h3',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-widget .content ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .four-popular-widget .content ul li',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-widget .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .four-popular-widget .content h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-widget .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .four-popular-widget .content p',
            ]
        );
        $this->add_control(
            'v_btn_color',
            [
                'label'     => __( 'Button Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-widget .content .popular-link' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'v_btn_typography',
                'label'    => __( 'Button Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .four-popular-widget .content .popular-link',
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label'     => __( 'Button Text Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-program-area .four-popular-buttons .default-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label'     => __( 'Button Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-program-area .four-popular-buttons .default-btn' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_h_color',
            [
                'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .four-popular-program-area .four-popular-buttons .default-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typography',
                'label'    => __( 'Button Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .four-popular-program-area .four-popular-buttons .default-btn',
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Program Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'program',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'program_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'program',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $program_array = new \WP_Query( $args );

        ?>

        <!-- Four Popular Program Area Start -->
        <div class="four-popular-program-area ptb-100">
            <div class="container">
                <div class="popular-heading">
                    <?php if( $settings['top_title']): ?>
                        <span class="title">
                            <?php echo wp_kses_post( $settings['top_title'] ); ?>
                        </span>
                    <?php endif; ?>
                    <?php if( $settings['title']): ?>
                        <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                    <?php endif; ?>
                </div>
                <div class="four-popular-slider-widget">
                    <div class="swiper four-popular-slider">
                        <div class="swiper-wrapper">
                            <?php
                                $i=1;
                                while($program_array->have_posts()):
                                $program_array->the_post();
                                $id                =  get_the_ID();
                                $program_top_title  = get_field( 'program_top_title' );
                            ?>
                            <div class="swiper-slide">
                                <div class="four-popular-widget">
                                    <?php if(get_the_post_thumbnail_url() != ''): ?>
                                        <div class="image">
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><img src="<?php echo get_the_post_thumbnail_url( $id, 'falar_post_thumb' ); ?>" alt="image"></a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="content">
                                        <ul>
                                            <?php if($program_top_title): ?>
                                                <li>
                                                    <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/graduate.svg') ?>" alt="ico">
                                                    <?php echo wp_kses_post($program_top_title); ?>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php the_title(); ?></a>
                                        </h3>
                                        <?php echo the_excerpt(); ?>
                                        <?php if( $settings['view_btn']): ?>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="popular-link">
                                                <span><?php echo wp_kses_post( $settings['view_btn'] ); ?></span>
                                                <i class="<?php echo wp_kses_post( $settings['view_btn_icon'] ); ?>"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php $i++; endwhile; wp_reset_postdata();?>
                        </div>
                    </div>
                    <div class="four-popular-buttons">
                        <?php if( $settings['btn_url']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="default-btn">
                                <span><?php echo wp_kses_post( $settings['btn_text'] ); ?></span>
                                <i class="<?php echo wp_kses_post( $settings['btn_icon'] ); ?>"></i>
                            </a>
                        <?php endif; ?>
                        <div class="swiper-btn">
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Four Popular Program Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Popular_Program );