<?php
/**
 * Program Four Widget
*/

namespace Elementor;
class Falar_Program_Four extends Widget_Base {

	public function get_name() {
        return 'Program_Four';
    }

	public function get_title() {
        return __( 'Program Four', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-tools';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'program_section',
			[
				'label' => __( 'Program', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $list_items = new Repeater();

            $list_items->add_control(
                'title',
                [
                    'label' => __( 'Main Title', 'falar-toolkit' ),
                    'default' => __( 'Major Programs', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_items->add_control(
                'limit',
                [
                    'label' => esc_attr__( 'Posts Limit', 'falar-toolkit' ),
                    'description' => esc_attr__( 'Choose posts limit', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,

                    'default' => '7',

                ]
            );

            $list_items->add_control(
                'categories',
                [
                    'label' => esc_attr__( 'Show Only Specific Categories', 'falar-toolkit' ),
                    'description' => esc_attr__( 'Enter categories slugs to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'options' => falar_toolkit_get_page_program_cat_el(),

                ]
            );

            $list_items->add_control(
                'order',
                [
                    'label' => esc_attr__( 'Order', 'falar-toolkit' ),
                    'description' => esc_attr__( '', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'desc' => esc_attr__( 'Descending', 'falar-toolkit' ),
                        'asc' => esc_attr__( 'Ascending', 'falar-toolkit' ),
                    ],
                    'default' => 'desc',

                ]
            );

            $this->add_control(
                'programs',
                [
                    'label' => __('Program Items', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .program-main-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .program-main-title h2',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Link Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faculty-list .item' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Link Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .faculty-list .item',
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>


        <!-- Program Main Warp Start -->
        <div class="all-program-area">
            <?php $tab_i = 1; foreach($settings['programs'] as $tab): 
            $limit = ( isset( $tab['limit'] ) && is_numeric($tab['limit']) ) ? intval( $tab['limit'] ) : 8;
            $orderby = ( isset($tab['order_by']) && $tab['order_by'] ) ? esc_attr( $tab['order_by'] ) : 'post_date';
            $order = ( isset($tab['order']) && $tab['order'] ) ? esc_attr( $tab['order'] ) : 'desc';

            if($tab['categories']){
                $posts = new \WP_Query( array(
                    'post_type' => 'program',
                    'posts_per_page' => $limit,
                    'orderby' => $orderby,
                    'order' => $order,
                    'tax_query' => array(
                        array (
                            'taxonomy' => 'program_cat',
                            'field' => 'name',
                            'terms' => $tab['categories'],
                        )
                    ),
                ));
            }else{
                $posts = new \WP_Query( array(
                    'post_type' => 'program',
                    'posts_per_page' => $limit,
                    'orderby' => $orderby,
                    'order' => $order,
                ));
            }
            ?>
            <div class="program-main-warp pb-100">
                <div class="container">
                    <div class="row border-bottom g-4">
                        <div class="col-lg-6">
                            <div class="program-main-title">
                                <h2><?php echo esc_html($tab['title']); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faculty-list style2">
                                <?php
                                    $i=1;
                                    while($posts->have_posts()):
                                    $posts->the_post();
                                    $id              =  get_the_ID();
                                ?>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="item <?php if($i == 1): ?>top<?php endif; ?>">
                                        <?php the_title(); ?>
                                        <i class="ti ti-caret-right-filled"></i>
                                    </a>
                                <?php $i++; endwhile; wp_reset_postdata();?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php $tab_i++; endforeach; ?>
        </div>
        <!-- Program Main Warp End -->

        <?php
    }

}

Plugin::instance()->widgets_manager->register( new Falar_Program_Four );