<?php
/**
 * Question Two Widget
 */

namespace Elementor;
class Falar_Question_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Question_Two_Section';
    }

	public function get_title() {
        return __( 'Question Two Section', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Question_Two_Area',
			[
				'label' => __( 'Question Two Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('International Student Faqs', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $list_item = new Repeater();

            $list_item->add_control(
                'question_title',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_item->add_control(
                'question_content',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

            $this->add_control(
                'question_image',
                [
                    'label' => __( 'Quetion Image', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );


        $this->end_controls_section();

        $this->start_controls_section(
			'question_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content h2',
            ]
        );
        $this->add_control(
            'faq_title_color',
            [
                'label'     => __( 'Faq Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'faq_title_typography',
                'label'    => __( 'Faq Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-button',
            ]
        );
        $this->add_control(
            'faq_content_color',
            [
                'label'     => __( 'Faq Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-body p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'faq_content_typography',
                'label'    => __( 'Faq Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .question-content .accordion-question .accordion-item .accordion-body p',
            ]
        );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        $question_item = $settings['question_item'];
		?>

        <!-- Question Warp Start -->
        <div class="question-warp ptb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="question-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal3">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?>
                            
                            <div class="accordion-question">
                                <div class="accordion" id="faqAccordion">
                                    <?php $i = 1;  foreach( $question_item as $item_question ): 
                                        $cl='';
                                        if ($i == 1) {
                                            $cl='';
                                        }else {
                                            $cl='collapsed';
                                        }

                                        if($i <= 10):
                                    ?>
                                    <?php if( $item_question['question_title']): ?>
                                        <div class="accordion-item">
                                            <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse1<?php echo $i; ?>">
                                                <?php echo esc_attr( $item_question['question_title']) ?>
                                            </button>

                                            <div id="collapse1<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                    <p><?php echo wp_kses_post( $item_question['question_content']) ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php endif; $i++; endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="question-images">
                            <?php if( $settings['question_image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($settings['question_image']['url'] ) ?>" alt="image">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Question Warp End -->
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Falar_Question_Two );