<?php
/**
 * Residence Widget
 */

namespace Elementor;
class Falar_Residence extends Widget_Base {

	public function get_name() {
        return 'Falar_Residence';
    }

	public function get_title() {
        return __( 'Residence', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Residence_Area',
			[
				'label' => __( 'Residence Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar Residence', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Apply early to residence — you do not need to wait for your program acceptance!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'image',
            [
                'label'       => __( 'Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'content_two',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text1',
            [
                'label'       => __( 'Button Text One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Apply To Residence', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url1',
            [
                'label'       => __( 'Button Url One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text2',
            [
                'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Book A Campus Tour', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url2',
            [
                'label'       => __( 'Button Url Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'residence_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .residence-content-widget .residence-button .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .residence-content-widget .residence-button .default-btn' => 'background: {{VALUE}}',
					]
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .residence-content-widget .residence-button .default-btn',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $link_item    = $settings['link_item'];
        ?>

        <!-- Residence Warp Start -->
        <div class="residence-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="residence-content-widget">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if( $settings['image']['url'] != '' ): ?>
                                <div class="image">
                                    <img src="<?php echo esc_url($settings['image']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                            <?php if( $settings['content_two']): ?>
                                <?php echo wp_kses_post( $settings['content_two'] ); ?>
                            <?php endif; ?>
                            <div class="residence-button">
                                <?php if( $settings['button_text1']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['button_url1'] ); ?>" class="default-btn">
                                        <?php echo wp_kses_post( $settings['button_text1'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if( $settings['button_text2']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['button_url2'] ); ?>" class="residence-link">
                                        <span><?php echo wp_kses_post( $settings['button_text2'] ); ?></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="accessibility-link-widget">
                            <div class="accessibility-link-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item <?php if ($item_link['active_style']=='1'): ?>inactive<?php elseif($item_link['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <div class="icon">
                                            <i class="ti ti-caret-right-filled"></i>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Residence Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Residence );