<?php
/**
 * Schedule Widget
 */

namespace Elementor;
class Falar_Schedule extends Widget_Base {

	public function get_name() {
        return 'Falar_Schedule';
    }

	public function get_title() {
        return __( 'Schedule', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Schedule_Area',
			[
				'label' => __( 'Schedule Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'shortcode',
            [
                'label'   => __( 'Schedule Form Shortcode', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'schedule_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .select-option h3' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .select-option h3',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .applicant-details h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .applicant-details h3',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

       <div class="schedule-warp ptb-100">
            <div class="container">
                <div class="schedule-form">
                    <?php echo do_shortcode( $settings['shortcode'] ); ?>
                </div>
            </div>
        </div>
        <!-- Schedule Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Schedule );