<?php
/**
 * Service One Widget
 */

namespace Elementor;
class Falar_Service extends Widget_Base {

	public function get_name() {
        return 'Falar_Service';
    }

	public function get_title() {
        return __( 'Service', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Service_Area',
			[
				'label' => __( 'Service Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The world is changing and so we are in the wave', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The mission of Falar is to serve as a digital gateway and information hub for all members of the university community.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('New Programs', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label'       => __( 'Button Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'card_feature_content',
				[
					'label'       => __( 'Feature Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('5 New programs on health sector.', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'service_item',
                [
                    'label' => esc_html__('Add Service Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            
            $this->add_control(
				'service_img1',
				[
					'label'       => __( 'Service Image One', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
				'service_img2',
				[
					'label'       => __( 'Service Image Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

            $this->add_control(
				'award_icon',
				[
					'label'       => __( 'Awards Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            
            $this->add_control(
                'number',
                [
                    'label'       => __( 'Number', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('15', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'target',
                [
                    'label'       => __( 'Target', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('+', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'award_content',
                [
                    'label'       => __( 'Award Content', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('AWARDS COLLECTED IN BIO RESEARCH FIELD', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'service_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-content h2, .service-content .h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-content h2, .service-content .h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-content p',
                ]
            );
            $this->add_control(
				'feature_title_color',
				[
					'label'     => __( 'Feature Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-content .service-list li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_title_typography',
                    'label'    => __( 'Feature Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-content .service-list li',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-content .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-content .default-btn',
                ]
            );
            $this->add_control(
				'award_number_color',
				[
					'label'     => __( 'Award Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-image .service-counter h2, .service-image .service-counter .h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'award_number_typography',
                    'label'    => __( 'Award Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-image .service-counter h2, .service-image .service-counter .h2',
                ]
            );

            $this->add_control(
				'award_content_color',
				[
					'label'     => __( 'Award Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .service-image .service-counter p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'award_content_typography',
                    'label'    => __( 'Award Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .service-image .service-counter p',
                ]
            );

            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .bg-E8E8F4' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $service_item = $settings['service_item'];
        ?>

        <!-- Service Warp Start -->
        <div class="service-warp bg-E8E8F4 ptb-100">
            <div class="container">
                <div class="row align-items-start g-4">
                    <div class="col-lg-6">
                        <div class="service-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?> 
                            <?php if( $settings['content']): ?>
                                <p>
                                    <?php echo wp_kses_post( $settings['content'] ); ?>
                                </p>
                            <?php endif; ?>
                            <?php if( $settings['btn_link']): ?>
                                <a href="<?php echo wp_kses_post( $settings['btn_link'] ); ?>" class="default-btn">
                                    <?php echo wp_kses_post( $settings['btn_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                            <ul class="service-list">
                                <?php foreach($service_item as $item_service): ?>
                                    <li>
                                        <i class="ti ti-check"></i>
                                        <?php echo wp_kses_post( $item_service['card_feature_content'] ); ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="service-image">
                            <div class="row">
                                <div class="col-lg-6 col-md-6">
                                    <div class="image reveal2">
                                        <?php if( $settings['service_img1']['url'] != '' ): ?>
                                            <img src="<?php echo esc_url($settings['service_img1']['url'] ) ?>" alt="image">
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="image style2 reveal2">
                                        <?php if( $settings['service_img2']['url'] != '' ): ?>
                                            <img src="<?php echo esc_url($settings['service_img2']['url'] ) ?>" alt="image">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="service-counter">
                                <div class="d-flex align-items-center justify-content-center">
                                    <div class="icon">
                                        <div class="icon style">
                                            <?php if( $settings['award_icon']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url($settings['award_icon']['url'] ) ?>" alt="image">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php if( $settings['number']): ?>
                                        <h2 class="counter">
                                            <?php echo wp_kses_post( $settings['number'] ); ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if( $settings['target']): ?>
                                        <h2 class="plus"><?php echo wp_kses_post( $settings['target'] ); ?></h2>
                                    <?php endif; ?>
                                </div>
                                <?php if( $settings['award_content']): ?>
                                    <p><?php echo wp_kses_post( $settings['award_content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Service Warp End -->

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Service );