<?php
/**
 * Single Career Widget
 */

namespace Elementor;
class Falar_Single_Career extends Widget_Base {

	public function get_name() {
        return 'Falar_Single_Career';
    }

	public function get_title() {
        return __( 'Single Career', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Single_Career_Area',
			[
				'label' => __( 'Single Career Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_item = new Repeater();

            $list_item->add_control(
                'info_items',
                [
                    'label'       => __( 'Top Info', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'top_info_item',
                [
                    'label' => esc_html__('Add Top Info Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );
            $this->add_control(
                'title',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Job Description', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'content',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('We are seeking a skilled and motivated DevOps Engineer to join our dynamic team. As a DevOps Engineer, you will play a crucial role in designing, implementing, and maintaining our continuous integration, delivery, and deployment pipelines. Your expertise in automating processes, optimizing infrastructure, and ensuring seamless software releases will contribute to the overall efficiency and reliability of our software development lifecycle.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'title2',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Responsibilities:', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Responsibilities Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Responsibilities Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'title3',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Qualifications::', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $list_itemss = new Repeater();

            $list_itemss->add_control(
				'qualifications_title',
				[
					'label'       => __( 'Qualifications Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'qualifications_item',
                [
                    'label' => esc_html__('Add Qualifications Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemss->get_controls(),
                ]
            );

            $this->add_control(
                'title4',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Benefits that we will cover', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $list_itemsss = new Repeater();

            $list_itemsss->add_control(
				'benefits_title',
				[
					'label'       => __( 'Benefits Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'benefits_item',
                [
                    'label' => esc_html__('Add Benefits Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_itemsss->get_controls(),
                ]
            );

            $this->add_control(
                'bottom_content',
                [
                    'label'       => __( 'Title', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('If you are a proactive and detail-oriented DevOps Engineer with a passion for building and maintaining robust infrastructure and streamlined deployment processes, we encourage you to apply and become a valuable part of our dedicated team', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'button_text',
                [
                    'label'       => __( 'Button Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('Apply Now', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'button_url',
                [
                    'label'       => __( 'Button Url', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'single_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .job-description h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .job-description h3',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .job-description p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .job-description p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .job-responsibilities h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .job-responsibilities h3',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );
            $this->add_control(
				'list_color',
				[
					'label'     => __( 'List Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ul li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'list_typography',
                    'label'    => __( 'List Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} ul li',
                ]
            );
            $this->add_control(
				'benefit_bg_color',
				[
					'label'     => __( 'Benefits Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-job-details' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .job-details-button-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .job-details-button-content .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .job-details-button-content .default-btn',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $top_info_item        = $settings['top_info_item'];
        $info_item            = $settings['info_item'];
        $qualifications_item  = $settings['qualifications_item'];
        $benefits_item        = $settings['benefits_item'];

        ?>

        <!-- Job Details Warp Start -->
       <div class="job-details-warp ptb-100">
            <div class="container">
                <div class="job-description inner-job-widget">
                    <ul class="description-list">
                        <?php foreach($top_info_item as $item_top_info): ?>
                            <li>
                                <span><?php echo wp_kses_post( $item_top_info['info_items'] ); ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php if( $settings['title']): ?>
                        <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                    <?php endif; ?>
                    <?php if( $settings['content']): ?>
                        <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                </div>
                <div class="inner-job-widget job-responsibilities">
                    <?php if( $settings['title2']): ?>
                        <h3><?php echo wp_kses_post( $settings['title2'] ); ?></h3>
                    <?php endif; ?>
                    <ul class="responsibilities-list">
                        <?php foreach($info_item as $item_info): ?>
                            <li>
                                <i class="ti ti-arrow-right"></i>
                                <?php echo wp_kses_post( $item_info['info_title'] ); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="inner-job-widget job-responsibilities">
                    <?php if( $settings['title3']): ?>
                        <h3><?php echo wp_kses_post( $settings['title3'] ); ?></h3>
                    <?php endif; ?>
                    <ul class="responsibilities-list style2">
                        <?php foreach($qualifications_item as $item_qualifications): ?>
                            <li>
                                <i class="ti ti-arrow-right"></i>
                                <?php echo wp_kses_post( $item_qualifications['qualifications_title'] ); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="inner-job-details">
                    <div class="inner-job-widget job-benefits">
                        <?php if( $settings['title4']): ?>
                            <h3><?php echo wp_kses_post( $settings['title4'] ); ?></h3>
                        <?php endif; ?>
                        <ul class="benefits-list">
                            <?php foreach($benefits_item as $item_benefits): ?>
                                <li>
                                    <i class="ti ti-circle-check-filled"></i>
                                    <?php echo wp_kses_post( $item_benefits['benefits_title'] ); ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="job-details-button-content inner-job-widget">
                    <?php if( $settings['bottom_content']): ?>
                        <p><?php echo wp_kses_post( $settings['bottom_content'] ); ?></p>
                    <?php endif; ?>
                    <?php if( $settings['button_url']): ?>
                        <a href="<?php echo wp_kses_post( $settings['button_url'] ); ?>" class="default-btn">
                            <?php echo wp_kses_post( $settings['button_text'] ); ?> <i class="ti ti-arrow-narrow-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
       </div>
       <!-- Job Details Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Single_Career );