<?php
/**
 * Single Events Widget
 */

namespace Elementor;
class Falar_Single_Events extends Widget_Base {

	public function get_name() {
        return 'Falar_Single_Events';
    }

	public function get_title() {
        return __( 'Single Events', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Single_Events_Area',
			[
				'label' => __( 'Single Events Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Businesses rely on accountants to monitor their performance, compliance and financial health. Your first year will involve common curriculum shared by all business administration students, providing you with an understanding of how companies work. Topics of study include communications, finance, human resources and marketing — all areas of business you’ll impact as an accountant.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Learn how accounting supports business', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Businesses rely on accountants to monitor their performance, compliance and financial health. Your first year will involve common curriculum shared by all business administration students, providing you with an understanding of how companies work. Topics of study include communications, finance, human resources and marketing — all areas of business you’ll impact as an accountant.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Speaker', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'content3',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $list_item = new Repeater();

            $list_item->add_control(
				'image',
				[
					'label'       => __( 'Speaker Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
			);
            
            $this->add_control(
                'speaker_item',
                [
                    'label' => esc_html__('Add speaker Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );


        $this->add_control(
            'title3',
            [
                'label'       => __( 'Info Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Event Details', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'info_title',
				[
					'label'       => __( 'Info Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'info',
				[
					'label'       => __( 'Info', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'info_item',
                [
                    'label' => esc_html__('Add Information Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'btn_text',
                [
                    'label'       => __( 'Button Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('Apply To The Faculty Now', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'btn_url',
                [
                    'label'       => __( 'Button Url', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('#', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'single_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .event-details-content h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .event-details-content h4',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .event-big-warp p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .event-big-warp p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .event-details-content h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .event-details-content h4',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'site_info_title_color',
				[
					'label'     => __( 'Site Info Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget .facilities-item span' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_title_typography',
                    'label'    => __( 'Site Info Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small-widget .facilities-item span',
                ]
            );
            $this->add_control(
				'site_info_color',
				[
					'label'     => __( 'Site Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget .facilities-item  p' => 'color: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_info_typography',
                    'label'    => __( 'Site Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small-widget .facilities-item p',
                ]
            );
            $this->add_control(
				'site_area_bg_color',
				[
					'label'     => __( 'Site Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small-widget' => 'background: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .facilities-small' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .facilities-small',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $speaker_item = $settings['speaker_item'];
        $info_item     = $settings['info_item'];
        ?>

        <!-- Event Details Warp Start -->
        <div class="event-details-warp ptb-100">
            <div class="container">
                <div class="row g-5">
                    <div class="col-lg-8">
                        <div class="event-big-warp">
                            <div class="blog-title">
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="event-details-content">
                                <?php if( $settings['title']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title'] ); ?></h4>
                                <?php endif; ?>
                                <?php if( $settings['content2']): ?>
                                    <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="event-speaker-widget">
                                <?php if( $settings['title2']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title2'] ); ?></h4>
                                <?php endif; ?>
                                <div class="row g-4 justify-content-center">
                                    <?php foreach($speaker_item as $item_speaker): ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="speaker-image">
                                                <?php if( $item_speaker['image']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($item_speaker['image']['url'] ) ?>" alt="image">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="event-details-content2">
                                <?php if( $settings['content3']): ?>
                                    <?php echo wp_kses_post( $settings['content3'] ); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="facilities-small-widget event-small-widget">
                            <?php if( $settings['title3']): ?>
                                <h5><?php echo wp_kses_post( $settings['title3'] ); ?></h5>
                            <?php endif; ?>
                            <?php foreach($info_item as $item_info): ?>
                                <div class="facilities-item">
                                    <span><?php echo wp_kses_post( $item_info['info_title'] ); ?></span>
                                    <?php echo wp_kses_post( $item_info['info'] ); ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <?php if( $settings['btn_url']): ?>
                            <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="default-btn facilities-small"><?php echo wp_kses_post( $settings['btn_text'] ); ?>
                                <i class="ti ti-arrow-narrow-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Event Details Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Single_Events );