<?php
/**
 * Story Card Widget
 */

namespace Elementor;
class Falar_Story_Card extends Widget_Base {

	public function get_name() {
        return 'Falar_Story_Card';
    }

	public function get_title() {
        return __( 'Story Card', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Story_Card_Area',
			[
				'label' => __( 'Story Card Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'card_img',
            [
                'label'       => __( 'Card Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Card Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Campus Story', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Card Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('A rigorous program that combines foundational medical knowledge.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View Detsils', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'arrow_icon',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'links_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dream-story-card .content h2, .dream-story-card .content .h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .dream-story-card .content h2, .dream-story-card .content .h2',
                ]
            );

            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dream-story-card .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .dream-story-card .content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dream-story-card .content .view-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .dream-story-card .content .view-link',
                ]
            );

            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dream-story-card' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <div class="dream-story-card">
            <?php if( $settings['card_img']['url'] != '' ): ?>
                <div class="image">
                    <img src="<?php echo esc_url($settings['card_img']['url'] ) ?>" class="dream-image" alt="image">
                </div>
            <?php endif; ?>
            <div class="content">
                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                <?php if( $settings['btn_url']): ?>
                    <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="view-link">
                        <span> <?php echo wp_kses_post( $settings['btn_text'] ); ?></span>
                        <i class="<?php echo esc_attr( $settings['arrow_icon']) ?>"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Story_Card );