<?php
/**
 * Support Widget
 */

namespace Elementor;
class Falar_Support extends Widget_Base {

	public function get_name() {
        return 'Falar_Support';
    }

	public function get_title() {
        return __( 'Support', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Support_Area',
			[
				'label' => __( 'Support Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'support_image1',
            [
                'label'       => __( 'Support Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'support_image2',
            [
                'label'       => __( 'Support Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'logo',
            [
                'label'       => __( 'Logo', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'text_shape',
            [
                'label'       => __( 'Text Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Support Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Our students dream of possibilities. Together, we can create opportunities to help them realize their true potential. When you give to Falar, you help us prepare students for a better career and a better life.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Your support tells students that someone believes in them, and that is a powerful message to encourage.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'button_text1',
            [
                'label'   => __( 'Button Text One', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Donate Monthly', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url1',
            [
                'label'   => __( 'Button Url One', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_text2',
            [
                'label'   => __( 'Button Text Two', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Make A One Time Gift', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_url2',
            [
                'label'   => __( 'Button Url Two', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phn_top_title',
            [
                'label'       => __( 'Phone Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default' => __('Information For Donors', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phn_title',
            [
                'label'       => __( 'Phone Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default' => __('Call', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phn_no',
            [
                'label'       => __( 'Phone Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phn_bottom_content',
            [
                'label'   => __( 'Phone Bottom Content', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('For any kind of admission support', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'reg_title',
            [
                'label'       => __( 'Registration Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default' => __('Charitable Registration Number', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'reg_no',
            [
                'label'       => __( 'Registration Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
			'support_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-support-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-support-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-support-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-support-content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            $this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'btn_color2',
				[
					'label'     => __( 'Button Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-support-content .info-button .style2' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography2',
                    'label'    => __( 'Button Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-support-content .info-button .style2',
                ]
            );
            $this->add_control(
				'btn_bg_color2',
				[
					'label'     => __( 'Button background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-support-content .info-button .style2' => 'background-color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'num_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .support-content .support-content-style .content h4' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .support-content .support-content-style .content h4',
                ]
            );
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .support-warp::before' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- International Support Warp Start -->
        <div class="international-support-warp pb-100">
            <div class="container">
                <div class="row align-items-center g-4">
                    <div class="col-lg-6">
                        <div class="international-support-image">
                            <?php if( $settings['support_image1']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($settings['support_image1']['url'] ) ?>" alt="image">
                            <?php endif; ?>
                            <div class="small-image">
                                <?php if( $settings['support_image2']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['support_image2']['url'] ) ?>" alt="image">
                                <?php endif; ?>
                            </div>
                            <div class="round-shape">
                                <?php if( $settings['logo']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['logo']['url'] ) ?>" class="main-logo" alt="image">
                                <?php endif; ?>
                                <?php if( $settings['text_shape']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url($settings['text_shape']['url'] ) ?>" class="text-shape" alt="image">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="international-support-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2 active"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                            <div class="info-button">
                                <?php if( $settings['button_text1']): ?>
                                    <a href="<?php echo esc_html( $settings['button_url1'] ); ?>" class="default-btn">
                                        <?php echo esc_html( $settings['button_text1'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if( $settings['button_text2']): ?>
                                    <a href="<?php echo esc_html( $settings['button_url2'] ); ?>" class="default-btn style2">
                                        <?php echo esc_html( $settings['button_text2'] ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="international-info">
                                <div class="row align-items-center">
                                    <div class="col-lg-6">
                                        <div class="item-one">
                                            <?php if( $settings['phn_top_title']): ?>
                                                <h4><?php echo wp_kses_post( $settings['phn_top_title'] ); ?></h4>
                                            <?php endif; ?>
                                            <?php if( $settings['phn_title']): ?>
                                                <p><?php echo wp_kses_post( $settings['phn_title'] ); ?>  <a href="tel:<?php echo wp_kses_post( $settings['phn_no'] ); ?>"><?php echo wp_kses_post( $settings['phn_no'] ); ?></a></p>
                                            <?php endif; ?>
                                            <?php if( $settings['phn_bottom_content']): ?>
                                                <span><?php echo wp_kses_post( $settings['phn_bottom_content'] ); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="item-two">
                                            <?php if( $settings['reg_title']): ?>
                                                <h4><?php echo wp_kses_post( $settings['reg_title'] ); ?></h4>
                                            <?php endif; ?>
                                            <?php if( $settings['reg_no']): ?>
                                                <p><?php echo wp_kses_post( $settings['reg_no'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- International Support Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Support );