<?php
/**
 * Testimonials One Widget
 */

namespace Elementor;
class Falar_Testimonials_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Testimonials_Two';
    }

	public function get_title() {
        return __( 'Testimonials Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Testimonials_Two_Area',
			[
				'label' => __( 'Testimonials Two Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
                'user_image',
                [
                    'label'       => __( 'User Image', 'falar-toolkit' ),
                    'type'        => Controls_Manager::MEDIA,
                ]
            );
            $list_items->add_control(
                'name',
                [
                    'label'       => __( 'Name', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
                'time',
                [
                    'label'       => __( 'Time', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $list_items->add_control(
				'review_icons',
				[
					'label'       => __( 'Review Icons', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
				]
			);
            $list_items->add_control(
				'testimonials_title',
				[
					'label'       => __( 'Testimonials Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'testimonials_content',
				[
					'label'       => __( 'Testimonials Card Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'testimonials_item',
                [
                    'label' => esc_html__('Add Testimonials Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonials_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-review-widget h4, .home-four-review-widget .h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-review-widget h4, .home-four-review-widget .h4',
                ]
            );
            $this->add_control(
				'card_content_color',
				[
					'label'     => __( 'Card Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-review-widget .main' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_content_typography',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-review-widget .main',
                ]
            );

            $this->add_control(
				'name_color',
				[
					'label'     => __( 'Name Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-review-widget .star-details .review-details .content span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'name_typography',
                    'label'    => __( 'Name Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-review-widget .star-details .review-details .content span',
                ]
            );
            $this->add_control(
				'time_color',
				[
					'label'     => __( 'Time Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-review-widget .star-details .review-details .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'time_typography',
                    'label'    => __( 'Time Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-review-widget .star-details .review-details .content p',
                ]
            );
            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-review-widget' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $testimonials_item = $settings['testimonials_item'];
        ?>

        <!-- Student Review Warp Start -->
        <div class="student-review-warp pb-100 home-four-student-review">
            <div class="container">
                <div class="student-review-slider-warp">
                    <div class="swiper review-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($testimonials_item as $item_testimonials): ?>
                                <div class="swiper-slide">
                                    <div class="home-four-review-widget">
                                        <div class="star-details">
                                            <div class="review-details">
                                                
                                                <div class="image">
                                                    <?php if( $item_testimonials['user_image']['url'] != '' ): ?>
                                                        <img src="<?php echo esc_url($item_testimonials['user_image']['url'] ) ?>" alt="image">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="content">
                                                    <span><?php echo wp_kses_post( $item_testimonials['name'] ); ?></span>
                                                    <p><?php echo wp_kses_post( $item_testimonials['time'] ); ?></p>
                                                </div>
                                            </div>
                                            <ul class="star-list">
                                                <?php echo wp_kses_post( $item_testimonials['review_icons'] ); ?>
                                            </ul>
                                        </div>
                                        <h4><?php echo wp_kses_post( $item_testimonials['testimonials_title'] ); ?></h4>
                                        <p class="main"><?php echo wp_kses_post( $item_testimonials['testimonials_content'] ); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="swiper-pagination1"></div>
                </div>
            </div>
        </div>
        <!-- Student Review Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Testimonials_Two );