<?php
/**
 * Testimonials One Widget
 */

namespace Elementor;
class Falar_Testimonials extends Widget_Base {

	public function get_name() {
        return 'Falar_Testimonials';
    }

	public function get_title() {
        return __( 'Testimonials', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Testimonials_Area',
			[
				'label' => __( 'Testimonials Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Student’s Reviews', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('View All', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'review_icons',
				[
					'label'       => __( 'Review Icons', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
				]
			);
            $list_items->add_control(
				'testimonials_title',
				[
					'label'       => __( 'Testimonials Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'testimonials_content',
				[
					'label'       => __( 'Testimonials Card Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'user_image',
				[
					'label'       => __( 'User Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'name',
				[
					'label'       => __( 'Name', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'time',
				[
					'label'       => __( 'Time', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'testimonials_item',
                [
                    'label' => esc_html__('Add Testimonials Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonials_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-warp h2',
                ]
            );
			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .review-widget h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .review-widget h4',
                ]
            );
            $this->add_control(
				'card_content_color',
				[
					'label'     => __( 'Card Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .review-widget p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_content_typography',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .review-widget p',
                ]
            );

            $this->add_control(
				'name_color',
				[
					'label'     => __( 'Name Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .review-widget .review-details li' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'name_typography',
                    'label'    => __( 'Name Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .review-widget .review-details li',
                ]
            );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $testimonials_item = $settings['testimonials_item'];
        ?>

        <!-- Student Review Warp Start -->
        <div class="student-review-warp ptb-100">
            <div class="container">
                <div class="section-warp">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal2"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                    <?php if( $settings['button_text']): ?>
                        <a href="<?php echo esc_url( $link ); ?>" class="section-link">
                            <span><?php echo esc_html( $settings['button_text'] ); ?></span>
                            <i class="ti ti-arrow-narrow-right"></i>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="student-review-slider-warp">
                    <div class="swiper review-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($testimonials_item as $item_testimonials): ?>
                                <div class="swiper-slide">
                                    <div class="review-widget">
                                        <ul class="star-list">
                                            <?php echo wp_kses_post( $item_testimonials['review_icons'] ); ?>
                                        </ul>
                                        <h4><?php echo wp_kses_post( $item_testimonials['testimonials_title'] ); ?></h4>
                                        <p><?php echo wp_kses_post( $item_testimonials['testimonials_content'] ); ?></p>
                                        <ul class="review-details">
                                            <li>
                                                <?php if( $item_testimonials['user_image']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($item_testimonials['user_image']['url'] ) ?>" alt="image">
                                                <?php endif; ?>
                                            </li>
                                            <li>
                                                <span><?php echo wp_kses_post( $item_testimonials['name'] ); ?></span>
                                            </li>
                                            <li>
                                                <?php echo wp_kses_post( $item_testimonials['time'] ); ?>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="swiper-pagination1"></div>
                </div>
            </div>
        </div>
        <!-- Student Review Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Testimonials );