<?php
/**
 * Transfer One Widget
 */

namespace Elementor;
class Falar_Transfer extends Widget_Base {

	public function get_name() {
        return 'Falar_Transfer';
    }

	public function get_title() {
        return __( 'Transfer', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Transfer_Area',
			[
				'label' => __( 'Transfer Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Search And Transfer Your Credits', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'transfer_image',
				[
					'label'       => __( 'Transfer Card Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'transfer_title',
				[
					'label'       => __( 'Transfer Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'transfer_content',
				[
					'label'       => __( 'Transfer Card Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'transfer_btn_text',
				[
					'label'       => __( 'Transfer Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('Apply Now', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'transfer_btn_url',
				[
					'label'       => __( 'Transfer Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'transfer_item',
                [
                    'label' => esc_html__('Add Transfer Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'transfer_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
			$this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .transfer-credit-card .content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .transfer-credit-card .content h3',
                ]
            );
            $this->add_control(
				'card_content_color',
				[
					'label'     => __( 'Card Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .transfer-credit-card .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_content_typography',
                    'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .transfer-credit-card .content p',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .transfer-credit-card .content .apply-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .transfer-credit-card .content .apply-link',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $transfer_item = $settings['transfer_item'];
        ?>

        <!-- Transfer Credits Card Warp Start -->
       <div class="transfer-credit-warp ptb-100">
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['title']): ?>
                        <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row g-4 justify-content-center">
                    <?php foreach($transfer_item as $item_transfer): ?>
                        <div class="col-lg-4 col-md-6" data-cue="slideInUp">
                            <div class="transfer-credit-card">
                                <?php if( $item_transfer['transfer_image']['url'] != '' ): ?>
                                    <div class="image">
                                        <img src="<?php echo esc_url($item_transfer['transfer_image']['url'] ) ?>" alt="image">
                                    </div>
                                <?php endif; ?>
                                <div class="content">
                                    <h3>
                                        <?php echo wp_kses_post( $item_transfer['transfer_title'] ); ?>
                                    </h3>
                                    <p><?php echo wp_kses_post( $item_transfer['transfer_content'] ); ?></p>
                                    <?php if( $item_transfer['transfer_btn_url']): ?>
                                        <a href="<?php echo wp_kses_post( $item_transfer['transfer_btn_url'] ); ?>" class="apply-link">
                                            <span><?php echo wp_kses_post( $item_transfer['transfer_btn_text'] ); ?></span>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
       </div>
       <!-- Transfer Credits Card Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Transfer );