<?php
/**
 * Program Undergraduate Widget
 */

namespace Elementor;
class Falar_Undergraduate extends Widget_Base {

	public function get_name() {
        return 'Falar_Undergraduate';
    }

	public function get_title() {
        return __( 'Undergraduate', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Undergraduate_Area',
			[
				'label' => __( 'Undergraduate Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'program_image',
            [
                'label'       => __( 'Program Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('We Have <span>24+</span>Undergraduate Programs In Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Only here can you study a variety of disciplines by taking classes at any of our five colleges to create a path tailored to your passions and interests. Discover more about our 24 undergraduate majors and programs, explore the wide range of minors available across the university, and see examples of students’ unique major and minor combinations.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .undergraduate-program-content h2' => 'color: {{PROGRAM}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .undergraduate-program-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .undergraduate-program-content p' => 'color: {{PROGRAM}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .undergraduate-program-content p',
                ]
            );
           
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Undergraduate Programs Warp Start -->
        <div class="undergraduate-program-warp ptb-100">
            <div class="container">
                <div class="row g-4 align-items-center">
                    <div class="col-lg-6">
                        <?php if( $settings['program_image']['url'] != '' ): ?>
                            <div class="image">
                                <img src="<?php echo esc_url($settings['program_image']['url'] ) ?>" alt="image">
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-6">
                        <div class="undergraduate-program-content">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['content']): ?>
                                <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Undergraduate );