<?php
/**
 * Video Two Widget
 */

namespace Elementor;
class Falar_Video_Two extends Widget_Base {

	public function get_name() {
        return 'Falar_Video_Two';
    }

	public function get_title() {
        return __( 'Video Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Video_Area',
			[
				'label' => __( 'Video Two Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Do A Virtual Campus Tour', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label'       => __( 'Video Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'video_icon',
            [
                'label'       => __( 'Video Icon', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('ti ti-player-play-filled', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
				'shape',
				[
					'label'       => __( 'Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'video_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-video h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .inner-video h2',
                ]
            );

        $this->end_controls_section();
        
    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Virtual Video Warp Start -->
        <div class="virtual-video-warp pb-100">
            <div class="container">
                <div class="inner-video style2">
                    <?php if( $settings['video_url']): ?>
                        <video autoplay muted loop id="video">
                            <source src="<?php echo wp_kses_post( $settings['video_url'] ); ?>" type="video/mp4">
                        </video>
                    <?php endif; ?>
                    <?php if( $settings['title']): ?>
                        <h2>
                            <?php echo wp_kses_post( $settings['title'] ); ?>
                        </h2>
                    <?php endif; ?> 
                </div>
            </div>
        </div>
        <!-- Virtual Video Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Video_Two );