<?php
/**
 * Video One Widget
 */

namespace Elementor;
class Falar_Video extends Widget_Base {

	public function get_name() {
        return 'Falar_Video';
    }

	public function get_title() {
        return __( 'Video', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Video_Area',
			[
				'label' => __( 'Video Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'video_style',
            [
                'label' 	=> esc_html__( 'Video Style', 'falar-toolkit' ),
                'type' 		=> Controls_Manager::SELECT,
                'options' 	=> [
                    '1'         => esc_html__( 'Style One', 'falar-toolkit' ),
                    '2'         => esc_html__( 'Style Two', 'falar-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label'       => __( 'Video Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'video_icon',
            [
                'label'       => __( 'Video Icon', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('ti ti-player-play-filled', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
				'shape',
				[
					'label'       => __( 'Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();
        
    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Video Warp Start -->
        <?php if ($settings['video_style']=='1'): ?>
            <div class="video-warp">
                <div class="container">
                    <div class="inner-video">
                        <?php if( $settings['video_url']): ?>
                            <video autoplay muted loop id="video" controls>
                                <source src="<?php echo wp_kses_post( $settings['video_url'] ); ?>" type="video/mp4">
                            </video>
                        <?php endif; ?>
                        <?php if( $settings['video_icon']): ?>
                            <div class="video-btn" id="circle-play-b">
                                <div class="icon rounded-circle">
                                    <i class="<?php echo wp_kses_post( $settings['video_icon'] ); ?>"></i>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <div class="all-shapes">
                        <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="apply-shape2" alt="image">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['video_style']=='2'): ?>
            <div class="video-warp-style2">
                <div class="container">
                    <div class="inner-video">
                        <?php if( $settings['video_url']): ?>
                            <video autoplay muted loop id="video" controls>
                                <source src="<?php echo wp_kses_post( $settings['video_url'] ); ?>" type="video/mp4">
                            </video>
                        <?php endif; ?>
                        <?php if( $settings['video_icon']): ?>
                            <div class="video-btn" id="circle-play-b">
                                <div class="icon rounded-circle">
                                    <i class="<?php echo wp_kses_post( $settings['video_icon'] ); ?>"></i>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <!-- Video Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Video );